/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.formatter;

import com.aptana.editor.php.formatter.nodes.FormatterPHPCommentNode;
import com.aptana.editor.php.internal.parser.nodes.PHPASTWrappingNode;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.FormatterNodeRewriter;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.Program;

public class PHPFormatterNodeRewriter
extends FormatterNodeRewriter {
    private static final Pattern COMMENT_LINE_PATTERN = Pattern.compile("(\\S.*)");
    private static final String MULTI_LINE_COMMENT_PREFIX = "/*";

    public PHPFormatterNodeRewriter(IParseRootNode parseResultRoot, FormatterDocument document) {
        IParseNode child;
        List comments = null;
        if (parseResultRoot.getChildCount() == 1 && (child = parseResultRoot.getChild(0)) instanceof PHPASTWrappingNode) {
            Program ast = ((PHPASTWrappingNode)child).getAST();
            comments = ast.comments();
        }
        this.insertComments(document, comments);
    }

    private void insertComments(FormatterDocument document, List<Comment> comments) {
        for (Comment node : comments) {
            int endingOffset;
            int startingOffset = node.getStart();
            String commentText = document.get(startingOffset, endingOffset = node.getEnd());
            if (commentText.startsWith(MULTI_LINE_COMMENT_PREFIX)) {
                Matcher matcher = COMMENT_LINE_PATTERN.matcher(commentText);
                boolean isFirstLine = true;
                while (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    this.addComment(startingOffset + start, startingOffset + end, new PHPCommentInfo(true, isFirstLine));
                    isFirstLine = false;
                }
                continue;
            }
            this.addComment(startingOffset, endingOffset, new PHPCommentInfo(false, false));
        }
    }

    public void rewrite(IFormatterContainerNode root) {
        super.rewrite(root);
        this.attachComments(root);
    }

    protected IFormatterNode createCommentNode(IFormatterDocument document, int startOffset, int endOffset, Object object) {
        PHPCommentInfo info = (PHPCommentInfo)object;
        return new FormatterPHPCommentNode(document, startOffset, endOffset, info.isMultiLine, info.isFirstLine);
    }

    private class PHPCommentInfo {
        boolean isMultiLine;
        boolean isFirstLine;

        PHPCommentInfo(boolean isMultiLine, boolean isFirstLine) {
            this.isMultiLine = isMultiLine;
            this.isFirstLine = isFirstLine;
        }
    }
}

